/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.BaseElementPropertySource;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyElementPropertySource
extends BaseElementPropertySource<PropertyElement, Property> {
    public PropertyElementPropertySource(PropertyElement adaptableObject) {
        super((BaseElement)adaptableObject);
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<PropertyElement>
    {
        NAME(Messages.PropertyElement_Name){

            public Object getPropertyValue(PropertyElement node) {
                return node.getName();
            }
        }
        ,
        DESCRIPTION(Messages.PropertyElement_Description){

            public Object getPropertyValue(PropertyElement node) {
                return node.getDescription();
            }
        }
        ,
        OWNING_TYPE(Messages.PropertyElement_OwningType){

            public Object getPropertyValue(PropertyElement node) {
                return node.getOwningType();
            }
        }
        ,
        CLASS_PROPERTY(Messages.PropertyElement_StaticProperty){

            public Object getPropertyValue(PropertyElement node) {
                return node.isClassProperty();
            }
        }
        ,
        INSTANCE_PROPERTY(Messages.PropertyElement_InstanceProperty){

            public Object getPropertyValue(PropertyElement node) {
                return node.isInstanceProperty();
            }
        }
        ,
        RETURN_TYPES(Messages.PropertyElement_ReturnTypes){

            public Object getPropertyValue(PropertyElement node) {
                if (node instanceof FunctionElement) {
                    return StringUtil.join((String)", ", (Collection)((FunctionElement)node).getReturnTypeNames());
                }
                return "";
            }
        }
        ,
        TYPES(Messages.PropertyElement_Types){

            public Object getPropertyValue(PropertyElement node) {
                return StringUtil.join((String)", ", (Collection)node.getTypeNames());
            }
        }
        ,
        DOCUMENTS(Messages.PropertyElement_Documents){

            public Object getPropertyValue(PropertyElement node) {
                return StringUtil.join((String)", ", (Collection)node.getDocuments());
            }
        }
        ,
        DEPRECATED(Messages.TypeElement_Deprecated){

            public Object getPropertyValue(PropertyElement node) {
                return node.isDeprecated();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

